/**
 * Tree menu
 * @author Siri Chongasamethaworn (goonohc@gmail.com)
 * @version 1.0 October 16, 2007
 * 
 * Ist  dies ein Tree menu? Eigentlich handelt es sich um die JavaScript Datenstruktur,
 * die den kompletten Modellbaum repr�sentiert. Dieser wird aus dem XML repr�sentierten 
 * Modell abgeleitet. Mit der Datenstruktur Tree sind allerdings die Methoden verbunden
 * zur Bedienung des  Baumes. Diese sind im Tree.prototype definiert. 
 */
var Tree=function(aa)
{
	this.treeId=aa;
	this.image=new Object();
	this.image.plus='images/plus.gif';
	this.image.minus='images/minus.gif';
	window.treeObj=this;
};

Tree.prototype=
{
	addEvent:function(ba,ca,da)
	{
	   if(typeof document.attachEvent=='undefined')
		   ba.addEventListener(ca,da,false);
	   else ba.attachEvent('on'+ca,da);
	},

	repaint:function()
	{
	   this.renderAll();
	},
	
	renderAll:function()
	{
	   if(window.treeObj.treeId)
	   {
		  var ea=document.getElementById(window.treeObj.treeId);
		  if(ea&&ea.tagName=='UL')
		  {
			 if(!ea.isRendered)
				 window.treeObj.renderUL(ea);
		  }
	   } 
	   else
	   {
		  var ea=document.getElementsByTagName('UL');
		  for(var i=0;i<ea.length;i++)
		  {
			 if(!ea.isRendered)window.treeObj.renderUL(ea);
		  }
	   }
	},

	renderNode:function(li)
	{
	   li.isRendered=true;
	   li.style.listStyleType='none';
	   li.style.verticalAlign='middle';
	   li.style.marginLeft='16px';
	   li.style.paddingLeft='0px';
	   li.style.listStyleType='none';
	   var fa=false;
	   var ga=li.firstChild;
	   while(ga.nextSibling)
	   {
		  var ga=ga.nextSibling;
		  if(ga.tagName=='UL')
		  {
			 ga.style.marginLeft='16px';
			 ga.style.paddingLeft='0px';
			 ga.style.display='none';
			 ga.isExpanded=false;

			 var ha=document.createElement('img');
			 ha.src=window.treeObj.image.plus;
			 ha.style.height='16px';
			 ha.style.width='16px';
			 ha.style.verticalAlign='middle';
			 ha.isImageNode=true;
			 ha.onclick=window.treeObj.toggleNodeEvent;
			 li.insertBefore(ha,li.firstChild);
			 fa=true;
		   }
	  } 
	  if(fa)
		li.style.marginLeft='0px';
   },

   renderUL:function(ul)
   {
	  ul.isRendered=true;
	  var ia=ul.parentNode;
	  if(ia&&ia.tagName=='LI')
	  {
		 var ja=document.createElement('img');
		 ja.src=window.treeObj.image.plus;
		 ja.style.height='16px';
		 ja.style.width='16px';
		 ja.style.verticalAlign='middle';
		 ja.isImageNode=true;
		 ja.onclick=window.treeObj.toggleNodeEvent;
		 ia.style.marginLeft='0px';
		 ia.insertBefore(ja,ia.firstChild);
	  } 
	  
	  var ka=ul.childNodes;
	  for(var c=0;c<ka.length;c++)
	  {
		 if(ka[c].tagName=='LI')
		 {
			ka[c].style.listStyleType='none';
			ka[c].style.verticalAlign='middle';
			ka[c].style.marginLeft='16px';
			ka[c].style.paddingLeft='0px';
			var la=ka[c].firstChild;
			while(la.nextSibling)
			{
			  var la=la.nextSibling;
			  if(la.tagName=='UL')
			  {
				 la.style.marginLeft='16px';
				 la.style.paddingLeft='0px';
				 la.style.display='none';
				 la.isExpanded=false;
				 window.treeObj.renderUL(la);
			  }
		    }
		  }
	   }
   },
   
   toggleNodeEvent:function(e)
   {
	  var ul=this.nextSibling;
	  while(ul&&ul.tagName!='UL')
		  ul=ul.nextSibling;
	  
	  if(ul.isExpanded)
		  window.treeObj.collapse(ul);
	  else 
		  window.treeObj.expand(ul);
	  return false;
   },
   
   expand:function(ma)
   {
	  if(ma.tagName!='LI')
		  ma=ma.parentNode;
	  if(ma.tagName!='LI')
		  return false;
	  ma.firstChild.src=this.image.minus;
	  
	  var na=ma.childNodes;
	  for(var u=0;u<na.length;u++)
	  {
		 if(na[u].tagName=='UL'&&na[u].style.visibility!='hidden')
		 {
			 na[u].style.display='block';
			 na[u].isExpanded=true;
			 if(na[u].onExpand)na[u].onExpand();
		 }
	  } 
	  return false;
   },
   
   collapse:function(oa)
   {
	   if(oa.tagName!='LI')
		   oa=oa.parentNode;
	   if(oa.tagName!='LI')
		   return false;
	   oa.firstChild.src=this.image.plus;
	   var pa=oa.childNodes;
	   for(var u=0;u<pa.length;u++)
	   {
		   if(pa[u].tagName=='UL'&&pa[u].style.visibility!='hidden')
		   {
			   pa[u].style.display='none';
			   pa[u].isExpanded=false;
			   if(pa[u].onCollapse)pa[u].onCollapse();
		   }
	   } 
	   return false;
   },
   
   expandAll:function(qa)
   {
	   if(qa==null)
		   qa=document.getElementById(this.treeId);
	   var ra=qa.getElementsByTagName('ul');
	   for(var u=0;u<ra.length;u++)
	   {
		   this.expand(ra[u]);
	   }
   },
   
   collapseAll:function(sa)
   {
	   if(sa==null)
		   sa=document.getElementById(this.treeId);
	   var ta=sa.getElementsByTagName('ul');
	   for(var u=0;u<ta.length;u++)
	   {
		   this.collapse(ta[u]);
	   }
   }
};