/**
 * A MagicCat web framework.
 * @author Siri Chongasamethaworn (goonohc@gmail.com)
 * @version 1.0 November 21, 2005
 * @since November 21, 2005
 */
var Stack=function()
{
	this.list=new Array()};
	Stack.prototype=
	{
		
		push:function(A)
		{
			this.list[this.list.length]=A
		},

		pop:function()
		{
			if(this.list.length>0)
			{
				var A=this.list[this.list.length-1];
				delete this.list[this.list.length-1];
				this.list.length--;
				return A
			}
		return null
	},

	size:function()
	{
		return this.list.length
	},

	clear:function()
	{
		if(this.list.length>0)
		{
			for(var A=this.list.length-1;A>=0;A--)
			{
				delete this.list[A]
			}
			this.list.length=0
		}
	},
	
	peek:function()
	{
		if(this.list.length>0)
		{
			return this.list[this.list.length-1]
		}
		return null
	}
};
	
var TEXT=function(){};
TEXT.load=function(A)
{
	var B;
	if(window.ActiveXObject)
	{
		try		{ B=new ActiveXObject("Msxml2.XMLHTTP")		}
		catch(C){ B=new ActiveXObject("Microsoft.XMLHTTP")	}
		if(B)
		{
			B.open("GET",A,false);
			B.send();
			return B.responseText
		}
	}
	else
	{
		if(window.XMLHttpRequest)
		{
			B=new XMLHttpRequest();
			B.open("GET",A,false);
			B.send(null);
			return B.responseText
		}
	}
	return""
};


var XML=function(){};
XML.request;
XML.isIE=false;

XML.load=function(A,E)
{
	try
	{
		if(window.ActiveXObject)
		{
			XML.isIE=true;
			if(document.location.protocol=="file:")
			{
				var B=new ActiveXObject("MSXML2.DOMDocument");
				B.async=true;
				showLoading();
				B.load(A);
				E(B);
				hideLoading()
			}
			else
			{
				try     { XML.request=new ActiveXObject("Msxml2.XMLHTTP")}
				catch(D){ XML.request=new ActiveXObject("Microsoft.XMLHTTP")}
				if(XML.request)
				{
					XML.request.onreadystatechange=XML.stateChange;
					XML.callback=E;
					XML.request.open("GET",A,true);
					XML.request.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
					showLoading();
					XML.request.send()
				}
			}
		}
		else
		{
			if(window.XMLHttpRequest)
			{
				XML.request=new XMLHttpRequest();
				XML.request.onreadystatechange=XML.stateChange;
				XML.callback=E;
				XML.request.open("GET",A,true);
				XML.request.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
				showLoading();
				XML.request.send(null)
			}
		}
	}
	catch(C){hideLoading()}
};

XML.stateChange=function()
{
	if(XML.request.readyState==4)
	{
		if(XML.request.status==0||XML.request.status==200)
		{
			XML.callback(XML.request.responseXML,XML.request.responseText)
		}
		else
		{
			alert("There was a problem retrieving the XML data.\n"+XML.request.statusText)
		}
		hideLoading()
	}
};


var Library=function(){};
Library.load=function(A)
{
	for(var D in A)
	{
		var C=A[D];
		for(var B=0;B<C.length;B++)
		{
			Library.loadScript(D,C)
		}
	}
};

Library.loadScript=function(file,functions)
{
	var isNotLoaded=false;
	for(var i=0;i<functions.length;i++)
	{
		if(window[functions[i]]) { continue }
		isNotLoaded=true;
		break
	}
	if(isNotLoaded)
	{
		if(typeof (contextPath)!="undefined")
		{
			file=contextPath+file
		}
		var text=TEXT.load(file);
		try
		{
			if(file.match(/\.lib$/gi))
			{
				var amp=text.indexOf("&");
				if(amp!=-1)
				{
					eval(N64.decode(text.substring(amp)))
				}
			}
			else
			{
				eval(text)
			}
		}
		catch(e) { alert(file+"\r\n"+e) }
		
		for(var i=0;i<functions.length;i++)
		{
			try
			{
				window[functions[i]]=eval(functions[i])
			}
			catch(e){}
		}
	}
};

function addEvent(C,B,D,A)
{
	if(!A)	{ A=false }
	
	if(typeof document.attachEvent=="undefined")
	{
		C.addEventListener(B,D,A)
	}
	else
	{
		C.attachEvent("on"+B,D)
	}
}

function removeEvent(C,B,D,A)
{
	if(!A){A=false}
	
	if(typeof document.detachEvent=="undefined")
	{
		C.removeEventListener(B,D,A)
	}
	else
	{
		C.detachEvent("on"+B,D)
	}
}

function encode(A)
{
	return typeof (encodeURIComponent)=="function"?encodeURIComponent(A):escape(A)
}

function decode(A)
{
	return typeof (decodeURIComponent)=="function"?decodeURIComponent(A):unescape(A)
}

function createElement(A)
{
	if(window.ActiveXObject)
	{
		var B=new ActiveXObject("Microsoft.XMLDOM");
		B.async=false;
		return B.createNode(1,A,"")
	}
	else
	{
		if(document.implementation&&document.implementation.createDocument)
		{
			var B=document.implementation.createDocument("","",null);
			return B.createElement(A)
		}
	}
}

function nodeValue(A)
{
	if(A.hasChildNodes())
	{
		return A.childNodes[0].nodeValue
	}
	return""
}

function firstChild(A)
{
	var B=A.firstChild;
	while(B)
	{
		if(B.nodeType==1) { return B }
		B=B.nextSibling
	}
	return null
}

function nextSibling(B)
{
	var A=B.nextSibling;
	while(A)
	{
		if(A.nodeType==1){return A}
		A=A.nextSibling
	}
	return null
}

function previousSibling(B)
{
	var A=B.previousSibling;
	while(A)
	{
		if(A.nodeType==1){return A}
		A=A.previousSibling
	}
	return null
}

function removeAll(A,B)
{
	var D=B==null?0:B;
	for(var C=A.childNodes.length-1;C>=D;C--)
	{
		A.removeChild(A.childNodes[C])
	}
}

function getFirstElementByTagName(A,C)
{
	if(A.hasChildNodes())
	{
		for(var B=0;B<A.childNodes.length;B++)
		{
			if(A.childNodes[B].nodeName==C)
			{
				return A.childNodes[B]
			}
		}
	}
	return null
}

function writeRow()
{
	var B=writeRow.arguments;
	var A=B[0];
	var E=B[0].insertRow(A.rows.length);
	while(E.rowIndex==undefined){}
	var D=E.rowIndex;
	for(var C=1;C<B.length;C++)
	{
		var F=E.insertCell(C-1);
		F.appendChild(B[C])
	}
	return E
}

function removeRow(A,B)
{
	var D=B==null?0:B;
	for(var C=A.rows.length-1;C>=D;C--)
	{
		A.deleteRow(C)
	}
}

var loadingDialog;
var timeoutid;
var isLoading=false;
addEvent(window,"load",hideLoading);

function showLoading()
{
	isLoading=true;
	if(loadingDialog) { loadingDialog.show() }
	else
	{
		if(typeof (Dialog)=="function")
		{
			loadingDialog=new Dialog();
			var B=typeof (messageLoading)=="undefined"?"Loading ...":messageLoading;
			loadingDialog.setHtml('<span class="loading">'+B+"</span>");
			loadingDialog.show()
		}
		else
		{
			var A=document.getElementById("popup");
			if(!A)
			{
				A=document.createElement("div");
				A.setAttribute("id","popup");
				A.innerHTML="Loading...";
				document.body.appendChild(A)
			}
		}
	}
	if(typeof (timeout)!="undefined")
	{
		timeoutid=setTimeout(alertTimeOut,timeout)
	}
}

function hideLoading()
{
	if(isLoading)
	{
		isLoading=false;
		if(loadingDialog)
		{
			loadingDialog.hide()
		}
		else
		{
			var A=document.getElementById("popup");
			if(A) { document.body.removeChild(A) } 
		}
	}
	clearTimeout(timeoutid)
}

function alertTimeOut()
{
	var A=typeof (timeoutMessage)!="undefined"?timeoutMessage:"Sorry, our server is too busy. Please try again later.";
	alert(A);
	hideLoading()
}

function getQueryString()
{
	var E=""+window.location.search;
	if(E!=""&&E!="undefined")
	{
		E=E.substring(1);
		var D=E.split("&");
		var C=new Array(D.length);
		for(var B=0;B<D.length;B++)
		{
			var A=D[B].split("=");
			C[B]=new Object();
			C[B].key=A[0];
			C[B].value=A[1]
		}
		return C
	}
};